// File XMLExample.java

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XMLExample
{
    public static void main(String[] args)
    {
        try
        {
            Example exmp = new Example();
            exmp.setInternalValue(4);
            exmp.setAge(10);
            exmp.myMap.put(5, "The value for key 5");

            String xml = marshallToXML(exmp);
            System.out.println(xml);

            // Null the variable so we can actualy see if we unmarshalled it correctly
            exmp = null;

            exmp = (Example)unmarshallFromXML(Example.class, xml);
            System.out.println("Age = " + exmp.getAge());
            System.out.println("Map value for key '5' = '" + exmp.myMap.get(5) + "'");

        }
        catch (JAXBException ex)
        {
            Logger.getLogger(XMLExample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Converts an object to its XML representation
     * @param fromObject the object to create the XML based on
     * @return the XML string
     * @throws JAXBException
     */
    public static String marshallToXML(Object fromObject) throws JAXBException
    {
        JAXBContext context = JAXBContext.newInstance(fromObject.getClass());
        Marshaller marshaller = context.createMarshaller();

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal(fromObject, baos);

        return baos.toString();
    }

    /**
     * Converts XML representation to an object
     * @param toClass the class to create from the XML
     * @param XML the XML containing the object data
     * @return the object
     * @throws JAXBException
     */
    public static Object unmarshallFromXML(Class toClass, String XML) throws JAXBException
    {
        JAXBContext context = JAXBContext.newInstance(toClass);
        Unmarshaller unmarshaller = context.createUnmarshaller();

        ByteArrayInputStream bais = new ByteArrayInputStream(XML.getBytes());

        return unmarshaller.unmarshal(bais);
    }
}