/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.gstreamer.Caps;
import org.gstreamer.Gst;
import org.gstreamer.lowlevel.ReferenceManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceManagerTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("ReferenceManagerTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    public boolean waitGC(Reference<? extends Object> ref) throws InterruptedException {
        System.gc();
        for (int i = 0; ref.get() != null && i < 20; ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        return ref.get() == null;
    }

    @Test
    public void testReference() throws Exception {
        Object ref = new Object();
        Caps target = new Caps("video/x-raw-rgb");
        ReferenceManager.addKeepAliveReference(ref, target);
        WeakReference<Caps> targetRef = new WeakReference<Caps>(target);
        target = null;
        Assert.assertFalse((String)"target collected prematurely", (boolean)this.waitGC(targetRef));
        ref = null;
        Assert.assertTrue((String)"target not collected when ref is collected", (boolean)this.waitGC(targetRef));
    }

    @Test
    public void testMultipleReferences() throws Exception {
        Object ref1 = new Object();
        Object ref2 = new Object();
        Caps target = new Caps("video/x-raw-rgb");
        ReferenceManager.addKeepAliveReference(ref1, target);
        ReferenceManager.addKeepAliveReference(ref2, target);
        WeakReference<Caps> targetRef = new WeakReference<Caps>(target);
        target = null;
        Assert.assertFalse((String)"target collected prematurely", (boolean)this.waitGC(targetRef));
        ref1 = null;
        Assert.assertFalse((String)"target collected after only one ref disposed", (boolean)this.waitGC(targetRef));
        ref2 = null;
        Assert.assertTrue((String)"target not collected when ref is dispose", (boolean)this.waitGC(targetRef));
    }
}

