/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.nio.channels.Pipe;
import org.gstreamer.Bin;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.TagList;
import org.gstreamer.elements.DecodeBin;
import org.gstreamer.io.ReadableByteChannelSrc;
import org.gstreamer.io.WriteableByteChannelSink;

public class OutputStreamSinkTest {
    static final String name = "InputStreamSrcTest";

    public static void main(String[] args) {
        Pipe pipeChannel;
        if ((args = Gst.init(name, args)).length < 1) {
            System.err.println("Usage: InputStreamSrcTest <filename>");
            System.exit(1);
        }
        try {
            pipeChannel = Pipe.open();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Pipeline inputPipe = new Pipeline("input pipeline");
        Element filesrc = ElementFactory.make("filesrc", "File source");
        filesrc.set("location", args[0]);
        WriteableByteChannelSink outputstream = new WriteableByteChannelSink(pipeChannel.sink(), "output stream");
        inputPipe.addMany(filesrc, outputstream);
        Element.linkMany(filesrc, outputstream);
        inputPipe.play();
        ReadableByteChannelSrc src = null;
        try {
            src = new ReadableByteChannelSrc(pipeChannel.source(), "input file");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        DecodeBin decodeBin = (DecodeBin)ElementFactory.make("decodebin", "Decode Bin");
        Pipeline pipe = new Pipeline("main pipeline");
        pipe.addMany(src, decodeBin);
        src.link((Element)decodeBin);
        final Bin audioBin = new Bin("Audio Bin");
        Element conv = ElementFactory.make("audioconvert", "Audio Convert");
        Element sink = ElementFactory.make("autoaudiosink", "sink");
        audioBin.addMany(conv, sink);
        Element.linkMany(conv, sink);
        audioBin.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
        pipe.add(audioBin);
        decodeBin.connect(new DecodeBin.NEW_DECODED_PAD(){

            public void newDecodedPad(Element elem, Pad pad, boolean last) {
                System.out.println("newDecodedPad");
                Pad audioPad = audioBin.getStaticPad("sink");
                if (pad.isLinked()) {
                    return;
                }
                Caps caps = pad.getCaps();
                Structure struct = caps.getStructure(0);
                if (struct.getName().startsWith("audio/")) {
                    System.out.println("Got audio pad");
                    pad.link(audioPad);
                }
            }
        });
        Bus bus = pipe.getBus();
        bus.connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                System.out.println("Got TAG event");
                for (String tag : tagList.getTagNames()) {
                    System.out.println("Tag " + tag + " = " + tagList.getValue(tag, 0));
                }
            }
        });
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                System.out.println("Error: code=" + code + " message=" + message);
            }
        });
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject source) {
                System.out.println("Got EOS!");
            }
        });
        pipe.play();
        Gst.main();
    }
}

