/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import java.util.List;
import org.gstreamer.Bin;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.PadDirection;
import org.gstreamer.Pipeline;
import org.gstreamer.StaticPadTemplate;
import org.gstreamer.elements.DecodeBin;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.elements.TypeFind;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactoryTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("test", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testMakeFakesrc() {
        Element e = ElementFactory.make("fakesrc", "source");
        Assert.assertNotNull((String)"Failed to create fakesrc", (Object)e);
    }

    @Test
    public void testMakeBin() {
        Element e = ElementFactory.make("bin", "bin");
        Assert.assertNotNull((String)"Failed to create bin", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
    }

    @Test
    public void testMakePipeline() {
        Element e = ElementFactory.make("pipeline", "bin");
        Assert.assertNotNull((String)"Failed to create pipeline", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
        Assert.assertTrue((String)"Element not a subclass of Pipeline", (boolean)(e instanceof Pipeline));
    }

    @Test
    public void testMakePlaybin() {
        Element e = ElementFactory.make("playbin", "bin");
        Assert.assertNotNull((String)"Failed to create playbin", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
        Assert.assertTrue((String)"Element not a subclass of Pipeline", (boolean)(e instanceof Pipeline));
        Assert.assertTrue((String)"Element not a subclass of PlayBin", (boolean)(e instanceof PlayBin));
    }

    @Test
    public void testCreateFakesrc() {
        ElementFactory factory = ElementFactory.find("fakesrc");
        Assert.assertNotNull((String)"Could not locate fakesrc factory", (Object)factory);
        Element e = factory.create("source");
        Assert.assertNotNull((String)"Failed to create fakesrc", (Object)e);
    }

    @Test
    public void testCreateBin() {
        ElementFactory factory = ElementFactory.find("bin");
        Assert.assertNotNull((String)"Could not locate bin factory", (Object)factory);
        Element e = factory.create("bin");
        Assert.assertNotNull((String)"Failed to create bin", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
    }

    @Test
    public void testCreatePipeline() {
        ElementFactory factory = ElementFactory.find("pipeline");
        Assert.assertNotNull((String)"Could not locate pipeline factory", (Object)factory);
        Element e = factory.create("bin");
        Assert.assertNotNull((String)"Failed to create pipeline", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
        Assert.assertTrue((String)"Element not a subclass of Pipeline", (boolean)(e instanceof Pipeline));
    }

    @Test
    public void testCreatePlaybin() {
        ElementFactory factory = ElementFactory.find("playbin");
        Assert.assertNotNull((String)"Could not locate pipeline factory", (Object)factory);
        System.out.println("PlayBin factory name=" + factory.getName());
        Element e = factory.create("bin");
        Assert.assertNotNull((String)"Failed to create playbin", (Object)e);
        Assert.assertTrue((String)"Element not a subclass of Bin", (boolean)(e instanceof Bin));
        Assert.assertTrue((String)"Element not a subclass of Pipeline", (boolean)(e instanceof Pipeline));
        Assert.assertTrue((String)"Element not a subclass of PlayBin", (boolean)(e instanceof PlayBin));
    }

    public boolean waitGC(WeakReference<? extends Object> ref) throws InterruptedException {
        System.gc();
        for (int i = 0; ref.get() != null && i < 10; ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        return ref.get() == null;
    }

    public void testGarbageCollection() throws Throwable {
        ElementFactory factory = ElementFactory.find("fakesrc");
        Assert.assertNotNull((String)"Could not locate fakesrc factory", (Object)factory);
        WeakReference<ElementFactory> ref = new WeakReference<ElementFactory>(factory);
        factory = null;
        Assert.assertTrue((String)"Factory not garbage collected", (boolean)this.waitGC(ref));
    }

    @Test
    public void testMakeGarbageCollection() throws Throwable {
        Element e = ElementFactory.make("fakesrc", "test");
        WeakReference<Element> ref = new WeakReference<Element>(e);
        e = null;
        Assert.assertTrue((String)"Element not garbage collected", (boolean)this.waitGC(ref));
    }

    @Test
    public void testCreateGarbageCollection() throws Throwable {
        ElementFactory factory = ElementFactory.find("fakesrc");
        Assert.assertNotNull((String)"Could not locate fakesrc factory", (Object)factory);
        Element e = factory.create("bin");
        WeakReference<Element> ref = new WeakReference<Element>(e);
        e = null;
        Assert.assertTrue((String)"Element not garbage collected", (boolean)this.waitGC(ref));
    }

    @Test
    public void makeDecodeBinTest() {
        Element elem = ElementFactory.make("decodebin", "foo");
        Assert.assertTrue((String)"decodebin element not instance of DecodeBin", (boolean)(elem instanceof DecodeBin));
        Assert.assertTrue((String)"decodebin not subclass of Bin", (boolean)(elem instanceof Bin));
    }

    @Test
    public void makeTypeFindTest() {
        Element elem = ElementFactory.make("typefind", "foo");
        Assert.assertTrue((String)"typefind element not instance of TypeFind", (boolean)(elem instanceof TypeFind));
    }

    @Test
    public void getStaticPadTemplates() {
        ElementFactory f = ElementFactory.find("fakesink");
        List<StaticPadTemplate> templates = f.getStaticPadTemplates();
        Assert.assertTrue((String)"No static pad templates found", (!templates.isEmpty() ? 1 : 0) != 0);
        StaticPadTemplate t = templates.get(0);
        Assert.assertEquals((String)"Not a sink", (Object)"sink", (Object)t.getName());
        Assert.assertEquals((String)"Not a sink", (Object)((Object)PadDirection.SINK), (Object)((Object)t.getDirection()));
    }
}

