/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Platform;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.gstreamer.Bus;
import org.gstreamer.BusTest;
import org.gstreamer.Element;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Message;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.TestPipe;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.message.EOSMessage;
import org.gstreamer.message.StateChangedMessage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BusTest {
    private static final API gst = GstNative.load(API.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("BusTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void endOfStream() {
        TestPipe pipe = new TestPipe("endOfStream");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        1 eosSignal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.EOS)eosSignal);
        for (Element elem : pipe.pipe.getSinks()) {
            gst.gst_element_post_message(elem, gst.gst_message_new_eos((GstObject)elem));
        }
        pipe.run();
        pipe.getBus().disconnect((Bus.EOS)eosSignal);
        Assert.assertTrue((String)"EOS signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void stateChanged() {
        TestPipe pipe = new TestPipe("stateChanged");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        2 stateChanged = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.STATE_CHANGED)stateChanged);
        gst.gst_element_post_message((Element)pipe.pipe, (Message)new StateChangedMessage(pipe.pipe, State.READY, State.PLAYING, State.VOID_PENDING));
        pipe.run();
        pipe.getBus().disconnect((Bus.STATE_CHANGED)stateChanged);
        Assert.assertTrue((String)"STATE_CHANGED signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void errorMessage() {
        TestPipe pipe = new TestPipe("errorMessage");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        3 errorSignal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.ERROR)errorSignal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_error((GstObject)pipe.src, msg, "testing error messages"));
        pipe.play().run();
        pipe.getBus().disconnect((Bus.ERROR)errorSignal);
        pipe.dispose();
        Assert.assertTrue((String)"ERROR signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void warningMessage() {
        TestPipe pipe = new TestPipe("warningMessage");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        4 signal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.WARNING)signal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        pipe.play();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_warning((GstObject)pipe.src, msg, "testing warning messages"));
        pipe.run();
        pipe.getBus().disconnect((Bus.WARNING)signal);
        pipe.dispose();
        Assert.assertTrue((String)"WARNING signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void infoMessage() {
        if (Platform.isWindows()) {
            return;
        }
        TestPipe pipe = new TestPipe("infoMessage");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        5 signal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.INFO)signal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        pipe.play();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_info((GstObject)pipe.src, msg, "testing warning messages"));
        pipe.run();
        pipe.getBus().disconnect((Bus.INFO)signal);
        pipe.dispose();
        Assert.assertTrue((String)"INFO signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void bufferingData() {
        TestPipe pipe = new TestPipe("bufferingData");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicInteger signalValue = new AtomicInteger(-1);
        AtomicReference signalSource = new AtomicReference();
        int PERCENT = 95;
        6 signal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.BUFFERING)signal);
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_buffering((GstObject)pipe.src, 95));
        pipe.play().run();
        pipe.getBus().disconnect((Bus.BUFFERING)signal);
        pipe.dispose();
        Assert.assertTrue((String)"BUFFERING signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Wrong percent value received for signal", (long)95L, (long)signalValue.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void tagsFound() {
        TestPipe pipe = new TestPipe("tagsFound");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        7 signal = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.TAG)signal);
        TagList tagList = new TagList();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_tag((GstObject)pipe.src, tagList));
        pipe.play().run();
        pipe.getBus().disconnect((Bus.TAG)signal);
        pipe.dispose();
        Assert.assertTrue((String)"TAG signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void anyMessage() {
        TestPipe pipe = new TestPipe("anyMessage");
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        8 listener = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.MESSAGE)listener);
        for (Element elem : pipe.pipe.getSinks()) {
            gst.gst_element_post_message(elem, gst.gst_message_new_eos((GstObject)elem));
        }
        pipe.play().run();
        pipe.getBus().disconnect((Bus.MESSAGE)listener);
        Assert.assertTrue((String)"EOS signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void postMessage() {
        TestPipe pipe = new TestPipe();
        AtomicBoolean signalFired = new AtomicBoolean(false);
        AtomicReference signalSource = new AtomicReference();
        9 listener = new /* Unavailable Anonymous Inner Class!! */;
        pipe.getBus().connect((Bus.MESSAGE)listener);
        pipe.getBus().post(new EOSMessage(pipe.src));
        pipe.run();
        Assert.assertTrue((String)"Message not posted", (boolean)signalFired.get());
        Assert.assertEquals((String)"Wrong source in message", (Object)pipe.src, signalSource.get());
    }
}

