/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Platform;
import java.util.List;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Plugin;
import org.gstreamer.PluginFeature;
import org.gstreamer.Registry;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegistryTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("RegistryTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void getDefault() {
        Registry registry = Registry.getDefault();
        Assert.assertNotNull((String)"Registry.getDefault() returned null", (Object)registry);
    }

    @Test
    public void listPlugins() {
        String PLUGIN = "vorbis";
        Registry registry = Registry.getDefault();
        ElementFactory.make("playbin", "test");
        ElementFactory.make("vorbisdec", "vorbis");
        ElementFactory.make("decodebin", "decoder");
        List<Plugin> plugins = registry.getPluginList();
        Assert.assertFalse((String)"No plugins found", (boolean)plugins.isEmpty());
        boolean pluginFound = false;
        for (Plugin p : plugins) {
            if (!p.getName().equals("vorbis")) continue;
            pluginFound = true;
        }
        Assert.assertTrue((String)"vorbis plugin not found", (boolean)pluginFound);
    }

    @Test
    public void filterPlugins() {
        if (Platform.isWindows()) {
            return;
        }
        String PLUGIN = "vorbis";
        Registry registry = Registry.getDefault();
        ElementFactory.make("playbin", "test");
        ElementFactory.make("vorbisdec", "vorbis");
        ElementFactory.make("decodebin", "decoder");
        boolean[] filterCalled = new boolean[]{false};
        List<Plugin> plugins = registry.getPluginList((Registry.PluginFilter)new /* Unavailable Anonymous Inner Class!! */, true);
        Assert.assertFalse((String)"No plugins found", (boolean)plugins.isEmpty());
        Assert.assertTrue((String)"PluginFilter not called", (boolean)filterCalled[0]);
        Assert.assertEquals((String)"Plugin list should contain 1 item", (long)1L, (long)plugins.size());
        Assert.assertEquals((String)"vorbis plugin not found", (Object)"vorbis", (Object)plugins.get(0).getName());
    }

    @Test
    public void listPluginFeatures() {
        String PLUGIN = "vorbis";
        String FEATURE = "vorbisdec";
        Registry registry = Registry.getDefault();
        ElementFactory.make("playbin", "test");
        ElementFactory.make("vorbisdec", "vorbis");
        ElementFactory.make("decodebin", "decoder");
        List<PluginFeature> features = registry.getPluginFeatureListByPlugin("vorbis");
        Assert.assertFalse((String)"No plugin features found", (boolean)features.isEmpty());
        boolean pluginFound = false;
        for (PluginFeature p : features) {
            if (!p.getName().equals("vorbisdec")) continue;
            pluginFound = true;
        }
        Assert.assertTrue((String)"vorbis plugin not found", (boolean)pluginFound);
    }

    @Test
    public void lookupFeature() {
        PluginFeature f = Registry.getDefault().findPluginFeature("decodebin");
    }
}

