/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pad;
import org.gstreamer.PadLinkReturn;
import org.gstreamer.PadTest;
import org.gstreamer.TagList;
import org.gstreamer.event.TagEvent;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PadTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("test", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public boolean waitGC(WeakReference<? extends Object> ref) throws InterruptedException {
        System.gc();
        for (int i = 0; ref.get() != null && i < 100; ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        return ref.get() == null;
    }

    @Test
    public void getPad() throws Exception {
        Element src = ElementFactory.make("fakesrc", "src");
        Element sink = ElementFactory.make("fakesink", "sink");
        Pad srcPad = src.getStaticPad("src");
        Pad sinkPad = sink.getStaticPad("sink");
        Assert.assertNotNull((String)"Could not get src pad", (Object)srcPad);
        Assert.assertNotNull((String)"Could not get sink pad", (Object)sinkPad);
        src = null;
        sink = null;
        WeakReference<Pad> srcRef = new WeakReference<Pad>(srcPad);
        WeakReference<Pad> sinkRef = new WeakReference<Pad>(sinkPad);
        srcPad = null;
        sinkPad = null;
        Assert.assertTrue((String)"Src pad not garbage collected", (boolean)this.waitGC(srcRef));
        Assert.assertTrue((String)"Sink pad not garbage collected", (boolean)this.waitGC(sinkRef));
    }

    @Test
    public void padLink() throws Exception {
        Element src = ElementFactory.make("fakesrc", "src");
        Element sink = ElementFactory.make("fakesink", "src");
        Pad srcPad = src.getStaticPad("src");
        Pad sinkPad = sink.getStaticPad("sink");
        Assert.assertEquals((String)"Could not link pads", (Object)PadLinkReturn.OK, (Object)srcPad.link(sinkPad));
    }

    @Test
    public void addEventProbe() {
        Element elem = ElementFactory.make("identity", "src");
        TagEvent ev = new TagEvent(new TagList());
        Pad sink = elem.getStaticPad("sink");
        AtomicReference e = new AtomicReference();
        1 event_probe = new /* Unavailable Anonymous Inner Class!! */;
        sink.addEventProbe((Pad.EVENT_PROBE)event_probe);
        sink.sendEvent(ev);
        Assert.assertEquals((String)"event_prober.probeEvent() was not called", (Object)ev, e.get());
        sink.removeEventProbe((Pad.EVENT_PROBE)event_probe);
        TagEvent ev2 = new TagEvent(new TagList());
        sink.sendEvent(ev2);
        Assert.assertNotSame((String)"event_prober.probeEvent() should not have been called", (Object)ev2, e.get());
    }
}

