/*
 * Decompiled with CFR 0.152.
 */
package ca.tylerburton.mymediaplayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.elements.PlayBin;

public class MyMediaPlayer {
    private PlayBin _playbin = null;
    private JProgressBar _progBar = null;
    JLabel _lblArtist = null;
    JLabel _lblAlbum = null;
    JLabel _lblTrack = null;
    JLabel _lblDuration = null;
    TimeUnit _scaleUnit = TimeUnit.SECONDS;

    public MyMediaPlayer() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final JFrame f = new JFrame("My Media Player");
                f.setDefaultCloseOperation(3);
                f.setLayout(new BorderLayout());
                JMenuBar menuBar = new JMenuBar();
                JMenu menu = new JMenu("File");
                menuBar.add(menu);
                JMenuItem menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        JFileChooser fc = new JFileChooser();
                        if (fc.showOpenDialog(f) == 0) {
                            MyMediaPlayer.this.playFile(fc.getSelectedFile());
                        }
                    }
                });
                f.setJMenuBar(menuBar);
                MyMediaPlayer.this._progBar = new JProgressBar();
                f.add((Component)MyMediaPlayer.this._progBar, "North");
                MyMediaPlayer.this._progBar.setMaximum(100);
                MyMediaPlayer.this._progBar.setMinimum(0);
                MyMediaPlayer.this._progBar.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent arg0) {
                        if (MyMediaPlayer.this._progBar.getWidth() == 0) {
                            return;
                        }
                        Point mouse = arg0.getPoint();
                        double perc = (double)mouse.x / (double)MyMediaPlayer.this._progBar.getWidth();
                        long duration = MyMediaPlayer.this._playbin.queryDuration((this).MyMediaPlayer.this._scaleUnit);
                        MyMediaPlayer.this._playbin.seek((long)((double)duration * perc), (this).MyMediaPlayer.this._scaleUnit);
                    }

                    @Override
                    public void mouseEntered(MouseEvent arg0) {
                    }

                    @Override
                    public void mouseExited(MouseEvent arg0) {
                    }

                    @Override
                    public void mousePressed(MouseEvent arg0) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent arg0) {
                    }
                });
                JPanel panel = new JPanel(new GridLayout(0, 2));
                f.add(panel);
                panel.add(new JLabel("Time: "));
                MyMediaPlayer.this._lblDuration = new JLabel("");
                panel.add(MyMediaPlayer.this._lblDuration);
                panel.add(new JLabel("Artist:"));
                MyMediaPlayer.this._lblArtist = new JLabel("                  ");
                panel.add(MyMediaPlayer.this._lblArtist);
                panel.add(new JLabel("Album: "));
                MyMediaPlayer.this._lblAlbum = new JLabel("");
                panel.add(MyMediaPlayer.this._lblAlbum);
                panel.add(new JLabel("Track: "));
                MyMediaPlayer.this._lblTrack = new JLabel("");
                panel.add(MyMediaPlayer.this._lblTrack);
                f.pack();
                if (f.getWidth() < 400) {
                    f.setSize(400, f.getHeight());
                }
                f.setVisible(true);
            }
        });
        this.initGstreamer();
        this._playbin.getBus().connect(new Bus.EOS(){

            @Override
            public void endOfStream(GstObject arg0) {
                MyMediaPlayer.this._lblArtist.setText("SONG");
                MyMediaPlayer.this._lblAlbum.setText("HAS");
                MyMediaPlayer.this._lblTrack.setText("FINISHED");
            }
        });
        this._playbin.getBus().connect(new Bus.TAG(){

            @Override
            public void tagsFound(GstObject source, TagList tagList) {
                for (String tagName : tagList.getTagNames()) {
                    if (tagName.equalsIgnoreCase("artist")) {
                        MyMediaPlayer.this._lblArtist.setText((String)tagList.getValues(tagName).get(0));
                        continue;
                    }
                    if (tagName.equalsIgnoreCase("album")) {
                        MyMediaPlayer.this._lblAlbum.setText((String)tagList.getValues(tagName).get(0));
                        continue;
                    }
                    if (!tagName.equalsIgnoreCase("title")) continue;
                    MyMediaPlayer.this._lblTrack.setText((String)tagList.getValues(tagName).get(0));
                }
            }
        });
        Gst.main();
        this._playbin.setState(State.NULL);
    }

    private void initGstreamer() {
        this._playbin = new PlayBin("AudioPlayer");
        this._playbin.setVideoSink(ElementFactory.make("fakesink", "videosink"));
        this.startPoll();
    }

    private synchronized void playFile(File file) {
        this._playbin.stop();
        if (file.exists()) {
            this._lblArtist.setText("");
            this._lblAlbum.setText("");
            this._lblTrack.setText("");
            this._playbin.setInputFile(file);
            this._playbin.setState(State.PLAYING);
        } else {
            this._lblArtist.setText("FILE NOT FOUND");
            this._lblAlbum.setText("FILE NOT FOUND");
            this._lblTrack.setText("FILE NOT FOUND");
        }
    }

    private void startPoll() {
        Thread task = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        PlayBin pipeline = MyMediaPlayer.this._playbin;
                        long position = pipeline.queryPosition(MyMediaPlayer.this._scaleUnit);
                        long duration = pipeline.queryDuration(MyMediaPlayer.this._scaleUnit);
                        MyMediaPlayer.this._progBar.setMaximum(100);
                        MyMediaPlayer.this._progBar.setValue((int)(position * 100L / duration));
                        int intCurMin = (int)(position / 60L);
                        String curMin = null;
                        curMin = intCurMin < 10 ? "0" + intCurMin : "" + intCurMin;
                        int intCurSec = (int)(position - (long)(60 * intCurMin));
                        String curSec = null;
                        curSec = intCurSec < 10 ? "0" + intCurSec : "" + intCurSec;
                        int intMaxMin = (int)(duration / 60L);
                        String maxMin = null;
                        maxMin = intMaxMin < 10 ? "0" + intMaxMin : "" + intMaxMin;
                        int intMaxSec = (int)(duration - (long)(60 * intMaxMin));
                        String maxSec = null;
                        maxSec = intMaxSec < 10 ? "0" + intMaxSec : "" + intMaxSec;
                        MyMediaPlayer.this._lblDuration.setText(String.valueOf(curMin) + ":" + curSec + "/" + maxMin + ":" + maxSec);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        };
        task.start();
    }
}

