/*
 * main.m
 *
 * Copyright (C) 2015 - Tyler Burton
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Objective-C imports
 */
#import <Foundation/Foundation.h>

#import "CoreGTK/CGTK.h"
#import "CoreGTK/CGTKBaseBuilder.h"
#import "CoreGTK/CGTKBuilder.h"

#import "AppDelegate.h"
#import "Track.h"

int main(int argc, char *argv[])
{	
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	/* This is called in all GTK applications. Arguments are parsed
    * from the command line and are returned to the application. */
    [CGTK autoInitWithArgc:argc andArgv:argv];
    	
	/* Create a builder to load GLADE file */
	CGTKBuilder *builder = [[CGTKBuilder alloc] init];
	
	if([builder addFromFileWithFilename:@"mac_app.glade" andErr:NULL] == 0)
	{
		NSLog(@"Error loading GUI file");
		return 1;
	}
	
	/* Create an AppDelegate to link to the GUI */
	AppDelegate *appDelegate = [[AppDelegate alloc] init];
	
	/* Get text field, wrapping returned Widget in new CGTKEntry */
	appDelegate.textField = [[[CGTKEntry alloc] initWithGObject:(GObject*)[[CGTKBaseBuilder 
		getWidgetFromBuilder:builder withName:@"entry"] WIDGET]] autorelease];
	
	/* Get slider, wrapping returned Widget in new CGTKScale */
	appDelegate.slider = [[[CGTKScale alloc] initWithGObject:(GObject*)[[CGTKBaseBuilder 
		getWidgetFromBuilder:builder withName:@"scale"] WIDGET]] autorelease];
	
	/* Create track class for AppDelegate */
	Track *track = [[Track alloc] init];
	appDelegate.track = [track autorelease];
	
	/* Pre-synchronize the GUI */
	[appDelegate updateUserInterface];
	
	/* Use signal dictionary to connect GLADE signals to Objective-C code */
	NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
		             [CGTKCallbackData withObject:[CGTK class] 
		             	andSEL:@selector(mainQuit)], @"endGtkLoop",
		             	
		             [CGTKCallbackData withObject:appDelegate 
		             	andSEL:@selector(mute)], @"muteButtonClicked",
		             	
		             [CGTKCallbackData withObject:appDelegate 
		             	andSEL:@selector(sliderChanged)], @"sliderValueChanged",
		             	
		             [CGTKCallbackData withObject:appDelegate 
		             	andSEL:@selector(takeValueForVolume)], @"takeValueForVolume",
		             nil];

	/* CGTKBaseBuilder is a helper class to maps GLADE signals to Objective-C code */
	[CGTKBaseBuilder connectSignalsToObjectsWithBuilder:builder andSignalDictionary:dic];
	
	/* Show the GUI */
	[[CGTKBaseBuilder getWidgetFromBuilder:builder withName:@"window"] showAll];
	
	/*
	 * Release allocated memory
	 */
	[builder release];
			
	/* All GTK applications must have a [CGTK main] call. Control ends here
     * and waits for an event to occur (like a key press or
     * mouse event). */
    [CGTK main];
	
	/*
	 * Release allocated memory
	 */	
	[appDelegate release];
	[pool release];
	
	// Return success
	return 0;
}
