import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;


public class MySWTProject {

	public static void main(String[] args) {
		
		Display display = new Display();
		
		Shell shell = new Shell(display); // Create a sell (window)
		shell.setText("Here is my window title"); // Set the shell title text
		
		Button button = new Button(shell, SWT.PUSH); // Create a push button
		button.setText("Push Me"); // Set it's label text
		button.pack(); // Resize it to be as large as needed
		
		// Add an action listener that will print text to the console when we click the button
		button.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}

			public void widgetSelected(SelectionEvent e) {
				System.out.println("The button was pressed!");	
			}
		});
		
		shell.pack(); // Resize the shell to be just as large as we need it to be
		shell.open(); // Start displaying the shell
		
		// Run while we still have a shell dispatch events as needed
		while(!shell.isDisposed()) {
			if(!display.readAndDispatch()) {
				display.sleep();
			}
		}

		// Free memory
		display.dispose();
		
	}

}
